

class Player
{
  int curLoc;

  //color playerColor;
  int playerRedTint;
  
  boolean isAlive;
  
  PImage playerImage;
  
  boolean holdingSingle = false;
  boolean holdingDouble = false;
  
  float animStartTime;
  float animTime;
  int animStartLoc;
  int animEndLoc;
  // 0 = single move, 1 = double move, 2 = block, 3 = punch, 4 = jump kick
  int animType;
  boolean animating = false;
  boolean attackAnim = false;
  
  
  
  

  public Player (PImage image, int loc, int playerRedTinting) {
    curLoc = loc;
    // playerColor = colorToSet;
    playerRedTint = playerRedTinting;
    
    isAlive = true;
    playerImage = image;
  }
  
  void prepSingleMove() {
    holdingSingle = true;
  }
  
  void execSingleMove(Player otherPlayer) {
    // if we just blocked this will be false on release
    if (holdingSingle && !animating && !otherPlayer.attackAnim)
    {
      int dirOffset = 1;
      
      // switch between left and right side bump value, magic magic magic
      if (otherPlayer.curLoc > curLoc)
        dirOffset = -1;
        
      int curStartLoc = curLoc;
        
      // see if an enemy is within 1 space, otherwise advance one space
      if ( abs(otherPlayer.curLoc - curLoc) == 1 ) {
         
         // if they're holding the second button we get knocked back 1
         if (otherPlayer.holdingDouble) {
           curLoc += dirOffset;
           
           otherPlayer.animBlock (otherPlayer.curLoc, otherPlayer.curLoc);
           
           otherPlayer.holdingDouble = false;
           
           blockSound.play(0);
         } else {
           // take their spot by knocking them back 2 and advancing
           otherPlayer.curLoc -= (2 * dirOffset);
           curLoc -= dirOffset;
         }
         
         animPunch (curStartLoc, curLoc);
         
         punchSound.play(0);
      } else {
        curLoc -= dirOffset;
      
        animSingleMove (curStartLoc, curLoc); 
        singleMoveSound.play(0);
      }
    }
      
    holdingSingle = false;
  }
  
  void prepDoubleMove() {
    holdingDouble = true;
  }
  
  void execDoubleMove(Player otherPlayer) {
    // if we just blocked this will be false on release
    if (holdingDouble && !animating && !otherPlayer.attackAnim) 
    {
      int dirOffset = 1;
      
      // switch between left and right side bump value, magic magic magic
      if (otherPlayer.curLoc > curLoc)
        dirOffset = -1;
        
      int curStartLoc = curLoc;
        
      // next to each other = toss attempt
      // 2 spaces away = leap attack attempt
      // otherwise move 2 spaces towards foe
      if ( abs(otherPlayer.curLoc - curLoc) == 1 ) {
        // holding single will counter this move
        if (otherPlayer.holdingSingle) {
          int enemyStartLoc = otherPlayer.curLoc;
          
          curLoc += (dirOffset * 2);
          otherPlayer.curLoc += (dirOffset * 2);
          
          otherPlayer.animBlock (enemyStartLoc, otherPlayer.curLoc);
          
          // player blocked and must re-hit the button
          otherPlayer.holdingSingle = false;
          
          blockSound.play(0);
        } else {
          curLoc -= (dirOffset * 2);
          otherPlayer.curLoc -= (dirOffset * 2);
        }
        
        animDoubleMove (curStartLoc, curLoc, true);
        jumpFlipSound.play(0);
      } else if ( abs(otherPlayer.curLoc - curLoc) == 2 ) {
        // holding single will counter this move
        if (otherPlayer.holdingSingle) {
          //they countered us, so we fly 1 past their location
          curLoc -= (dirOffset * 3);
          
          otherPlayer.animBlock (otherPlayer.curLoc, otherPlayer.curLoc);
          
          // player blocked and must re-hit the button
          otherPlayer.holdingSingle = false;
          
          blockSound.play(0);
        } else {
          // we jumped 2 spaces to kick them back 1
          curLoc -= (dirOffset * 2);
          otherPlayer.curLoc -= dirOffset;
        }
          
        animJumpKick (curStartLoc, curLoc);
        jumpKickSound.play(0);
      } else {
        curLoc -= 2 * dirOffset;
        
        animDoubleMove (curStartLoc, curLoc, false);
        
        doubleMoveSound.play (0);
      }
    }
   
    holdingDouble = false; 
  }
  
  PImage singleMove = loadImage("singleMove.png");
  PImage jumpImage = loadImage("jumpOver.png");
  PImage blockImage = loadImage("block.png");
  
  PImage punchImage = loadImage("punchLeft.png");
  PImage jumpKickImage = loadImage("jumpKick.png");
  
  void draw (Player otherPlayer) {
    checkIfAlive ();
    
    if (isAlive) {
      if (playerImage != null) {
        
        // why learn math when you can use junk like this???
        float imgFlipper = 1;
        
        pushMatrix();
        
        if (curLoc < otherPlayer.curLoc) {
          imgFlipper *= -1;
          
         scale(-1.0, 1.0);
        }
          
        //tint(255, 255, 255, 125);
        if (animStartTime + animTime > millis()) {
          
          //start at 50% fade at both start and end loc, but go to 100% by millis
          float alphaPercent = (animStartTime + animTime - millis()) / animTime;
          
          float startAlpha = alphaPercent / 4;
          float endAlpha = 1 - startAlpha;
            
          float curAnimLoc = animEndLoc - alphaPercent * (animEndLoc - animStartLoc);
          
          if (animType == 0) {
            tint(playerRedTint, 0, 255 - playerRedTint, endAlpha * 255);
            image (singleMove, imgFlipper * curAnimLoc * 64, 0, imgFlipper * 64, 64);
          } else if (animType == 1) {
            tint(playerRedTint, 0, 255 - playerRedTint, endAlpha * 255);
            image (jumpImage, imgFlipper * curAnimLoc * 64, 0, imgFlipper * 64, 64);
          } else if (animType == 2) {
            tint(playerRedTint, 0, 255 - playerRedTint, endAlpha * 255);
            image (blockImage, imgFlipper * curLoc * 64, 0, imgFlipper * 64, 64);
          } else if (animType == 3) {
            tint(playerRedTint, 0, 255 - playerRedTint, endAlpha * 255);
            image (punchImage, imgFlipper * curAnimLoc * 64, 0, imgFlipper * 64, 64);
          } else if (animType == 4) {
            tint(playerRedTint, 0, 255 - playerRedTint, endAlpha * 255);
            image (jumpKickImage, imgFlipper * curAnimLoc * 64, 0, imgFlipper * 64, 64);
          }
        } else {
         tint(playerRedTint, 0, 255 - playerRedTint, 255);
          //not animating, draw stationary player
         animating = false; 
         attackAnim = false;
         image (playerImage, imgFlipper * curLoc * 64, 0, imgFlipper * 64, 64);
        }
        
        popMatrix();
      } else {
        fill (playerRedTint, 0, 255 - playerRedTint);
        
        drawSquare (curLoc);
        
        animating = false;
      }
    }
  }
  
  void animSingleMove (int startLoc, int endLoc) {
    animStartLoc = startLoc;
    animEndLoc = endLoc;
    animStartTime = millis ();
    animTime = 70 / gameSpeed;
    animType = 0; 
    animating = true;
  }
  
  void animDoubleMove (int startLoc, int endLoc, boolean attack) {
    animStartLoc = startLoc;
    animEndLoc = endLoc;
    animStartTime = millis ();
    animTime = 160 / gameSpeed;
    animType = 1; 
    animating = true;
    
    if (attack)
      attackAnim = true;
  }
  
  void animBlock (int startLoc, int endLoc) {
    animStartTime = millis ();
    animTime = 150 / gameSpeed;
    animType = 2;
    animating = true; 
  }
  
  void animPunch (int startLoc, int endLoc) {
    animStartLoc = startLoc;
    animEndLoc = endLoc;
    animStartTime = millis ();
    animTime = 250 / gameSpeed;
    animType = 3; 
    animating = true;
    attackAnim = true;
  }
  
  void animJumpKick (int startLoc, int endLoc) {
    animStartLoc = startLoc;
    animEndLoc = endLoc;
    animStartTime = millis ();
    animTime = 250 / gameSpeed;
    animType = 4; 
    animating = true;
    attackAnim = true;
  }
  
  void checkIfAlive () {
    isAlive = curLoc >= boardLeft && curLoc <= boardRight; 
  }
}
