import ddf.minim.*;

color centerColor = color(140, 140, 140);
color boardColor = color(100, 100, 100);

int boardLeft = 0;
int boardRight = 10;

Player p1;
Player p2;

float startTime;

float dropTimer;

boolean matchStarted = false;

boolean playing = false;

boolean dropFromLeft = true;

int counterTick = 3;

String screenText = "";
float timeScreenTextExpires = 0;

float gameSpeed = 1;

int speedLevel = 0;

boolean showStartText = true;

Minim minim;

AudioPlayer singleMoveSound;
  AudioPlayer doubleMoveSound;
  AudioPlayer punchSound;
  AudioPlayer blockSound;
  AudioPlayer jumpFlipSound;
  AudioPlayer jumpKickSound;

void setup() {
  size(704, 64);
  noStroke();
  background(0);
  
  minim = new Minim(this);
    
  singleMoveSound = minim.loadFile ("SingleMove.wav", 2048);
  doubleMoveSound = minim.loadFile ("DoubleMove.wav", 2048);
  punchSound = minim.loadFile ("Punch.wav", 2048);
  blockSound = minim.loadFile ("Block.wav", 2048);
  jumpFlipSound = minim.loadFile ("JumpFlip.wav", 2048);
  jumpKickSound = minim.loadFile ("JumpKick.wav", 2048);
  
  reset();
}

void reset() {
  playing = false;
  
  boardLeft = 0;
  boardRight = 10;
  
  p1 = new Player (loadImage("StationaryPlayer.png"), 1, 255);
  p2 = new Player (loadImage("StationaryPlayer.png"), 9, 0);
  
  startTime = 0;
  dropTimer = 0;
  
  counterTick = 3;
  
  showStartText = true;
}

void kickoffTimer () {
  reset ();
  
  //game starts in 3 seconds from kickoff
  startTime = millis () + 2000;
  dropTimer = startTime;
  
  matchStarted = true;
}

void draw() {
  clearBoard();
  
  drawCenter();
  
  // this is true when the match was kicked off (space was pressed)
  if (startTime > millis ()) {
    int timerValue = (int)((startTime - millis()) / 1000);
    
    if (timerValue != counterTick) {
      counterTick = timerValue;
      print (counterTick  + "\n"); 
      
      // printing out 1 greater than the value so once "1" fades the fight starts
      String numText = "" + (counterTick + 1);
      setTextOnScreen (numText, 1000);
    }
  } else if (matchStarted) {
    playing = true;
    
    // checks to see if 1 second has passed since the last piece fell
    if (millis () - dropTimer > 1000 / gameSpeed) {
      // sets the timer counter to the current time (to wait 1 more second)
      dropTimer = millis ();
      
      // alternating dropping from the left and right
      if (dropFromLeft)
        boardLeft++;
      else
        boardRight--;
        
      dropFromLeft = !dropFromLeft;
    } 
  } else if (showStartText) {
    setTextOnScreen ("Press space to start match", 100000);
    
    showStartText = false;
  }
  
  p1.draw(p2);
  p2.draw(p1);
  
  // check to see if either player has fallen off the board
  if (matchStarted && (!p1.isAlive || !p2.isAlive) ) {
    if (!p1.isAlive)
      print ("p2 wins!\n");
    else if (!p2.isAlive)
      print ("p1 wins!\n");
    
    matchStarted = false; 
    playing = false;
  }
  
  drawScreenText ();
}

// expiration time in milliseconds from now
void setTextOnScreen (String textToSet, float expirationTime) {
  timeScreenTextExpires = millis () + expirationTime;
  screenText = textToSet;
}

void drawScreenText () {
  if (timeScreenTextExpires - millis () > 0) {
    textAlign(CENTER, CENTER);
    textSize(32);
    fill(255, 255, 255);
    text(screenText, width / 2, height / 2); 
  }
}

void drawCenter () {
  fill (centerColor);
  drawSquare (5);
}

void clearBoard () {
  background(0);
  
  fill (boardColor);
  
  for (int i = boardLeft; i <= boardRight; i++) {
    drawSquare (i);
  }
}

// draws a square in one of the 11 spaces available, indexed from 0 to 10
void drawSquare (int colNum) {
  rect (colNum * 64, 0, 64, 64);
}

//player 1's keys are 2,1 for single move double move respectively
//player 2's keys are 9,0 ""
void keyPressed () {
  if (playing) {
    if (key == '2')
      p1.prepSingleMove ();
    else if (key == '1')
      p1.prepDoubleMove ();
    else if (key == '9')
      p2.prepSingleMove ();
    else if (key == '0')
      p2.prepDoubleMove ();
  }
}

void keyReleased() {
  if (playing) {
    if (key == '2')
      p1.execSingleMove (p2);
    else if (key == '1')
      p1.execDoubleMove (p2);
    else if (key == '9')
      p2.execSingleMove (p1);
    else if (key == '0')
      p2.execDoubleMove (p1);
  }
  
  if (keyCode == UP) {
    if (speedLevel > 0) {
      speedLevel--;
      gameSpeed *= 2;
    }
  } if (keyCode == DOWN) {
    if (speedLevel < 3) {
      speedLevel++;
      gameSpeed /= 2;
    }
  }
    
  if (keyCode == DOWN || keyCode == UP) {
     switch (speedLevel) {
       case 0:
        setTextOnScreen ("Normal Speed (10 second game)", 2000);
        break;
       case 1:
        setTextOnScreen ("Half Speed (20 second game)", 2000);
        break;
       case 2:
        setTextOnScreen ("Quarter Speed (40 second game)", 2000);
        break;
       case 3:
        setTextOnScreen ("Eighth Speed (80 second game)", 2000);
        break;
     }
  }
   
  if (key == ' ' && !matchStarted)
    kickoffTimer ();
}
