import processing.core.*; 
import processing.xml.*; 

import ddf.minim.*; 

import java.applet.*; 
import java.awt.Dimension; 
import java.awt.Frame; 
import java.awt.event.MouseEvent; 
import java.awt.event.KeyEvent; 
import java.awt.event.FocusEvent; 
import java.awt.Image; 
import java.io.*; 
import java.net.*; 
import java.text.*; 
import java.util.*; 
import java.util.zip.*; 
import java.util.regex.*; 

public class sketch_10Seconds extends PApplet {



int centerColor = color(140, 140, 140);
int boardColor = color(100, 100, 100);

int boardLeft = 0;
int boardRight = 10;

Player p1;
Player p2;

float startTime;

float dropTimer;

boolean matchStarted = false;

boolean playing = false;

boolean dropFromLeft = true;

int counterTick = 3;

String screenText = "";
float timeScreenTextExpires = 0;

float gameSpeed = 1;

int speedLevel = 0;

boolean showStartText = true;

Minim minim;

AudioPlayer singleMoveSound;
  AudioPlayer doubleMoveSound;
  AudioPlayer punchSound;
  AudioPlayer blockSound;
  AudioPlayer jumpFlipSound;
  AudioPlayer jumpKickSound;

public void setup() {
  size(704, 64);
  noStroke();
  background(0);
  
  minim = new Minim(this);
    
  singleMoveSound = minim.loadFile ("SingleMove.wav", 2048);
  doubleMoveSound = minim.loadFile ("DoubleMove.wav", 2048);
  punchSound = minim.loadFile ("Punch.wav", 2048);
  blockSound = minim.loadFile ("Block.wav", 2048);
  jumpFlipSound = minim.loadFile ("JumpFlip.wav", 2048);
  jumpKickSound = minim.loadFile ("JumpKick.wav", 2048);
  
  reset();
}

public void reset() {
  playing = false;
  
  boardLeft = 0;
  boardRight = 10;
  
  p1 = new Player (loadImage("StationaryPlayer.png"), 1, 255);
  p2 = new Player (loadImage("StationaryPlayer.png"), 9, 0);
  
  startTime = 0;
  dropTimer = 0;
  
  counterTick = 3;
  
  showStartText = true;
}

public void kickoffTimer () {
  reset ();
  
  //game starts in 3 seconds from kickoff
  startTime = millis () + 2000;
  dropTimer = startTime;
  
  matchStarted = true;
}

public void draw() {
  clearBoard();
  
  drawCenter();
  
  // this is true when the match was kicked off (space was pressed)
  if (startTime > millis ()) {
    int timerValue = (int)((startTime - millis()) / 1000);
    
    if (timerValue != counterTick) {
      counterTick = timerValue;
      print (counterTick  + "\n"); 
      
      // printing out 1 greater than the value so once "1" fades the fight starts
      String numText = "" + (counterTick + 1);
      setTextOnScreen (numText, 1000);
    }
  } else if (matchStarted) {
    playing = true;
    
    // checks to see if 1 second has passed since the last piece fell
    if (millis () - dropTimer > 1000 / gameSpeed) {
      // sets the timer counter to the current time (to wait 1 more second)
      dropTimer = millis ();
      
      // alternating dropping from the left and right
      if (dropFromLeft)
        boardLeft++;
      else
        boardRight--;
        
      dropFromLeft = !dropFromLeft;
    } 
  } else if (showStartText) {
    setTextOnScreen ("Press space to start match", 100000);
    
    showStartText = false;
  }
  
  p1.draw(p2);
  p2.draw(p1);
  
  // check to see if either player has fallen off the board
  if (matchStarted && (!p1.isAlive || !p2.isAlive) ) {
    if (!p1.isAlive)
      print ("p2 wins!\n");
    else if (!p2.isAlive)
      print ("p1 wins!\n");
    
    matchStarted = false; 
    playing = false;
  }
  
  drawScreenText ();
}

// expiration time in milliseconds from now
public void setTextOnScreen (String textToSet, float expirationTime) {
  timeScreenTextExpires = millis () + expirationTime;
  screenText = textToSet;
}

public void drawScreenText () {
  if (timeScreenTextExpires - millis () > 0) {
    textAlign(CENTER, CENTER);
    textSize(32);
    fill(255, 255, 255);
    text(screenText, width / 2, height / 2); 
  }
}

public void drawCenter () {
  fill (centerColor);
  drawSquare (5);
}

public void clearBoard () {
  background(0);
  
  fill (boardColor);
  
  for (int i = boardLeft; i <= boardRight; i++) {
    drawSquare (i);
  }
}

// draws a square in one of the 11 spaces available, indexed from 0 to 10
public void drawSquare (int colNum) {
  rect (colNum * 64, 0, 64, 64);
}

//player 1's keys are 2,1 for single move double move respectively
//player 2's keys are 9,0 ""
public void keyPressed () {
  if (playing) {
    if (key == '2')
      p1.prepSingleMove ();
    else if (key == '1')
      p1.prepDoubleMove ();
    else if (key == '9')
      p2.prepSingleMove ();
    else if (key == '0')
      p2.prepDoubleMove ();
  }
}

public void keyReleased() {
  if (playing) {
    if (key == '2')
      p1.execSingleMove (p2);
    else if (key == '1')
      p1.execDoubleMove (p2);
    else if (key == '9')
      p2.execSingleMove (p1);
    else if (key == '0')
      p2.execDoubleMove (p1);
  }
  
  if (keyCode == UP) {
    if (speedLevel > 0) {
      speedLevel--;
      gameSpeed *= 2;
    }
  } if (keyCode == DOWN) {
    if (speedLevel < 3) {
      speedLevel++;
      gameSpeed /= 2;
    }
  }
    
  if (keyCode == DOWN || keyCode == UP) {
     switch (speedLevel) {
       case 0:
        setTextOnScreen ("Normal Speed (10 second game)", 2000);
        break;
       case 1:
        setTextOnScreen ("Half Speed (20 second game)", 2000);
        break;
       case 2:
        setTextOnScreen ("Quarter Speed (40 second game)", 2000);
        break;
       case 3:
        setTextOnScreen ("Eighth Speed (80 second game)", 2000);
        break;
     }
  }
   
  if (key == ' ' && !matchStarted)
    kickoffTimer ();
}


class Player
{
  int curLoc;

  //color playerColor;
  int playerRedTint;
  
  boolean isAlive;
  
  PImage playerImage;
  
  boolean holdingSingle = false;
  boolean holdingDouble = false;
  
  float animStartTime;
  float animTime;
  int animStartLoc;
  int animEndLoc;
  // 0 = single move, 1 = double move, 2 = block, 3 = punch, 4 = jump kick
  int animType;
  boolean animating = false;
  boolean attackAnim = false;
  
  
  
  

  public Player (PImage image, int loc, int playerRedTinting) {
    curLoc = loc;
    // playerColor = colorToSet;
    playerRedTint = playerRedTinting;
    
    isAlive = true;
    playerImage = image;
  }
  
  public void prepSingleMove() {
    holdingSingle = true;
  }
  
  public void execSingleMove(Player otherPlayer) {
    // if we just blocked this will be false on release
    if (holdingSingle && !animating && !otherPlayer.attackAnim)
    {
      int dirOffset = 1;
      
      // switch between left and right side bump value, magic magic magic
      if (otherPlayer.curLoc > curLoc)
        dirOffset = -1;
        
      int curStartLoc = curLoc;
        
      // see if an enemy is within 1 space, otherwise advance one space
      if ( abs(otherPlayer.curLoc - curLoc) == 1 ) {
         
         // if they're holding the second button we get knocked back 1
         if (otherPlayer.holdingDouble) {
           curLoc += dirOffset;
           
           otherPlayer.animBlock (otherPlayer.curLoc, otherPlayer.curLoc);
           
           otherPlayer.holdingDouble = false;
           
           blockSound.play(0);
         } else {
           // take their spot by knocking them back 2 and advancing
           otherPlayer.curLoc -= (2 * dirOffset);
           curLoc -= dirOffset;
         }
         
         animPunch (curStartLoc, curLoc);
         
         punchSound.play(0);
      } else {
        curLoc -= dirOffset;
      
        animSingleMove (curStartLoc, curLoc); 
        singleMoveSound.play(0);
      }
    }
      
    holdingSingle = false;
  }
  
  public void prepDoubleMove() {
    holdingDouble = true;
  }
  
  public void execDoubleMove(Player otherPlayer) {
    // if we just blocked this will be false on release
    if (holdingDouble && !animating && !otherPlayer.attackAnim) 
    {
      int dirOffset = 1;
      
      // switch between left and right side bump value, magic magic magic
      if (otherPlayer.curLoc > curLoc)
        dirOffset = -1;
        
      int curStartLoc = curLoc;
        
      // next to each other = toss attempt
      // 2 spaces away = leap attack attempt
      // otherwise move 2 spaces towards foe
      if ( abs(otherPlayer.curLoc - curLoc) == 1 ) {
        // holding single will counter this move
        if (otherPlayer.holdingSingle) {
          int enemyStartLoc = otherPlayer.curLoc;
          
          curLoc += (dirOffset * 2);
          otherPlayer.curLoc += (dirOffset * 2);
          
          otherPlayer.animBlock (enemyStartLoc, otherPlayer.curLoc);
          
          // player blocked and must re-hit the button
          otherPlayer.holdingSingle = false;
          
          blockSound.play(0);
        } else {
          curLoc -= (dirOffset * 2);
          otherPlayer.curLoc -= (dirOffset * 2);
        }
        
        animDoubleMove (curStartLoc, curLoc, true);
        jumpFlipSound.play(0);
      } else if ( abs(otherPlayer.curLoc - curLoc) == 2 ) {
        // holding single will counter this move
        if (otherPlayer.holdingSingle) {
          //they countered us, so we fly 1 past their location
          curLoc -= (dirOffset * 3);
          
          otherPlayer.animBlock (otherPlayer.curLoc, otherPlayer.curLoc);
          
          // player blocked and must re-hit the button
          otherPlayer.holdingSingle = false;
          
          blockSound.play(0);
        } else {
          // we jumped 2 spaces to kick them back 1
          curLoc -= (dirOffset * 2);
          otherPlayer.curLoc -= dirOffset;
        }
          
        animJumpKick (curStartLoc, curLoc);
        jumpKickSound.play(0);
      } else {
        curLoc -= 2 * dirOffset;
        
        animDoubleMove (curStartLoc, curLoc, false);
        
        doubleMoveSound.play (0);
      }
    }
   
    holdingDouble = false; 
  }
  
  PImage singleMove = loadImage("singleMove.png");
  PImage jumpImage = loadImage("jumpOver.png");
  PImage blockImage = loadImage("block.png");
  
  PImage punchImage = loadImage("punchLeft.png");
  PImage jumpKickImage = loadImage("jumpKick.png");
  
  public void draw (Player otherPlayer) {
    checkIfAlive ();
    
    if (isAlive) {
      if (playerImage != null) {
        
        // why learn math when you can use junk like this???
        float imgFlipper = 1;
        
        pushMatrix();
        
        if (curLoc < otherPlayer.curLoc) {
          imgFlipper *= -1;
          
         scale(-1.0f, 1.0f);
        }
          
        //tint(255, 255, 255, 125);
        if (animStartTime + animTime > millis()) {
          
          //start at 50% fade at both start and end loc, but go to 100% by millis
          float alphaPercent = (animStartTime + animTime - millis()) / animTime;
          
          float startAlpha = alphaPercent / 4;
          float endAlpha = 1 - startAlpha;
            
          float curAnimLoc = animEndLoc - alphaPercent * (animEndLoc - animStartLoc);
          
          if (animType == 0) {
            tint(playerRedTint, 0, 255 - playerRedTint, endAlpha * 255);
            image (singleMove, imgFlipper * curAnimLoc * 64, 0, imgFlipper * 64, 64);
          } else if (animType == 1) {
            tint(playerRedTint, 0, 255 - playerRedTint, endAlpha * 255);
            image (jumpImage, imgFlipper * curAnimLoc * 64, 0, imgFlipper * 64, 64);
          } else if (animType == 2) {
            tint(playerRedTint, 0, 255 - playerRedTint, endAlpha * 255);
            image (blockImage, imgFlipper * curLoc * 64, 0, imgFlipper * 64, 64);
          } else if (animType == 3) {
            tint(playerRedTint, 0, 255 - playerRedTint, endAlpha * 255);
            image (punchImage, imgFlipper * curAnimLoc * 64, 0, imgFlipper * 64, 64);
          } else if (animType == 4) {
            tint(playerRedTint, 0, 255 - playerRedTint, endAlpha * 255);
            image (jumpKickImage, imgFlipper * curAnimLoc * 64, 0, imgFlipper * 64, 64);
          }
        } else {
         tint(playerRedTint, 0, 255 - playerRedTint, 255);
          //not animating, draw stationary player
         animating = false; 
         attackAnim = false;
         image (playerImage, imgFlipper * curLoc * 64, 0, imgFlipper * 64, 64);
        }
        
        popMatrix();
      } else {
        fill (playerRedTint, 0, 255 - playerRedTint);
        
        drawSquare (curLoc);
        
        animating = false;
      }
    }
  }
  
  public void animSingleMove (int startLoc, int endLoc) {
    animStartLoc = startLoc;
    animEndLoc = endLoc;
    animStartTime = millis ();
    animTime = 70 / gameSpeed;
    animType = 0; 
    animating = true;
  }
  
  public void animDoubleMove (int startLoc, int endLoc, boolean attack) {
    animStartLoc = startLoc;
    animEndLoc = endLoc;
    animStartTime = millis ();
    animTime = 160 / gameSpeed;
    animType = 1; 
    animating = true;
    
    if (attack)
      attackAnim = true;
  }
  
  public void animBlock (int startLoc, int endLoc) {
    animStartTime = millis ();
    animTime = 150 / gameSpeed;
    animType = 2;
    animating = true; 
  }
  
  public void animPunch (int startLoc, int endLoc) {
    animStartLoc = startLoc;
    animEndLoc = endLoc;
    animStartTime = millis ();
    animTime = 250 / gameSpeed;
    animType = 3; 
    animating = true;
    attackAnim = true;
  }
  
  public void animJumpKick (int startLoc, int endLoc) {
    animStartLoc = startLoc;
    animEndLoc = endLoc;
    animStartTime = millis ();
    animTime = 250 / gameSpeed;
    animType = 4; 
    animating = true;
    attackAnim = true;
  }
  
  public void checkIfAlive () {
    isAlive = curLoc >= boardLeft && curLoc <= boardRight; 
  }
}
  static public void main(String args[]) {
    PApplet.main(new String[] { "--bgcolor=#FFFFFF", "sketch_10Seconds" });
  }
}
