/*
 * Decompiled with CFR 0.152.
 */
import ddf.minim.AudioPlayer;
import ddf.minim.Minim;
import processing.core.PApplet;
import processing.core.PImage;

public class sketch_10Seconds
extends PApplet {
    int centerColor = this.color(140, 140, 140);
    int boardColor = this.color(100, 100, 100);
    int boardLeft = 0;
    int boardRight = 10;
    Player p1;
    Player p2;
    float startTime;
    float dropTimer;
    boolean matchStarted = false;
    boolean playing = false;
    boolean dropFromLeft = true;
    int counterTick = 3;
    String screenText = "";
    float timeScreenTextExpires = 0.0f;
    float gameSpeed = 1.0f;
    int speedLevel = 0;
    boolean showStartText = true;
    Minim minim;
    AudioPlayer singleMoveSound;
    AudioPlayer doubleMoveSound;
    AudioPlayer punchSound;
    AudioPlayer blockSound;
    AudioPlayer jumpFlipSound;
    AudioPlayer jumpKickSound;

    public void setup() {
        this.size(704, 64);
        this.noStroke();
        this.background(0);
        this.minim = new Minim((PApplet)this);
        this.singleMoveSound = this.minim.loadFile("SingleMove.wav", 2048);
        this.doubleMoveSound = this.minim.loadFile("DoubleMove.wav", 2048);
        this.punchSound = this.minim.loadFile("Punch.wav", 2048);
        this.blockSound = this.minim.loadFile("Block.wav", 2048);
        this.jumpFlipSound = this.minim.loadFile("JumpFlip.wav", 2048);
        this.jumpKickSound = this.minim.loadFile("JumpKick.wav", 2048);
        this.reset();
    }

    public void reset() {
        this.playing = false;
        this.boardLeft = 0;
        this.boardRight = 10;
        this.p1 = new Player(this.loadImage("StationaryPlayer.png"), 1, 255);
        this.p2 = new Player(this.loadImage("StationaryPlayer.png"), 9, 0);
        this.startTime = 0.0f;
        this.dropTimer = 0.0f;
        this.counterTick = 3;
        this.showStartText = true;
    }

    public void kickoffTimer() {
        this.reset();
        this.dropTimer = this.startTime = (float)(this.millis() + 2000);
        this.matchStarted = true;
    }

    public void draw() {
        this.clearBoard();
        this.drawCenter();
        if (this.startTime > (float)this.millis()) {
            int n = (int)((this.startTime - (float)this.millis()) / 1000.0f);
            if (n != this.counterTick) {
                this.counterTick = n;
                sketch_10Seconds.print((String)(String.valueOf(this.counterTick) + "\n"));
                String string = "" + (this.counterTick + 1);
                this.setTextOnScreen(string, 1000.0f);
            }
        } else if (this.matchStarted) {
            this.playing = true;
            if ((float)this.millis() - this.dropTimer > 1000.0f / this.gameSpeed) {
                this.dropTimer = this.millis();
                if (this.dropFromLeft) {
                    ++this.boardLeft;
                } else {
                    --this.boardRight;
                }
                this.dropFromLeft = !this.dropFromLeft;
            }
        } else if (this.showStartText) {
            this.setTextOnScreen("Press space to start match", 100000.0f);
            this.showStartText = false;
        }
        this.p1.draw(this.p2);
        this.p2.draw(this.p1);
        if (!(!this.matchStarted || this.p1.isAlive && this.p2.isAlive)) {
            if (!this.p1.isAlive) {
                sketch_10Seconds.print((String)"p2 wins!\n");
            } else if (!this.p2.isAlive) {
                sketch_10Seconds.print((String)"p1 wins!\n");
            }
            this.matchStarted = false;
            this.playing = false;
        }
        this.drawScreenText();
    }

    public void setTextOnScreen(String string, float f) {
        this.timeScreenTextExpires = (float)this.millis() + f;
        this.screenText = string;
    }

    public void drawScreenText() {
        if (this.timeScreenTextExpires - (float)this.millis() > 0.0f) {
            this.textAlign(3, 3);
            this.textSize(32.0f);
            this.fill(255.0f, 255.0f, 255.0f);
            this.text(this.screenText, this.width / 2, this.height / 2);
        }
    }

    public void drawCenter() {
        this.fill(this.centerColor);
        this.drawSquare(5);
    }

    public void clearBoard() {
        this.background(0);
        this.fill(this.boardColor);
        int n = this.boardLeft;
        while (n <= this.boardRight) {
            this.drawSquare(n);
            ++n;
        }
    }

    public void drawSquare(int n) {
        this.rect(n * 64, 0.0f, 64.0f, 64.0f);
    }

    public void keyPressed() {
        if (this.playing) {
            if (this.key == '2') {
                this.p1.prepSingleMove();
            } else if (this.key == '1') {
                this.p1.prepDoubleMove();
            } else if (this.key == '9') {
                this.p2.prepSingleMove();
            } else if (this.key == '0') {
                this.p2.prepDoubleMove();
            }
        }
    }

    public void keyReleased() {
        if (this.playing) {
            if (this.key == '2') {
                this.p1.execSingleMove(this.p2);
            } else if (this.key == '1') {
                this.p1.execDoubleMove(this.p2);
            } else if (this.key == '9') {
                this.p2.execSingleMove(this.p1);
            } else if (this.key == '0') {
                this.p2.execDoubleMove(this.p1);
            }
        }
        if (this.keyCode == 38 && this.speedLevel > 0) {
            --this.speedLevel;
            this.gameSpeed *= 2.0f;
        }
        if (this.keyCode == 40 && this.speedLevel < 3) {
            ++this.speedLevel;
            this.gameSpeed /= 2.0f;
        }
        if (this.keyCode == 40 || this.keyCode == 38) {
            switch (this.speedLevel) {
                case 0: {
                    this.setTextOnScreen("Normal Speed (10 second game)", 2000.0f);
                    break;
                }
                case 1: {
                    this.setTextOnScreen("Half Speed (20 second game)", 2000.0f);
                    break;
                }
                case 2: {
                    this.setTextOnScreen("Quarter Speed (40 second game)", 2000.0f);
                    break;
                }
                case 3: {
                    this.setTextOnScreen("Eighth Speed (80 second game)", 2000.0f);
                }
            }
        }
        if (this.key == ' ' && !this.matchStarted) {
            this.kickoffTimer();
        }
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#FFFFFF", "sketch_10Seconds"});
    }

    class Player {
        int curLoc;
        int playerRedTint;
        boolean isAlive;
        PImage playerImage;
        boolean holdingSingle = false;
        boolean holdingDouble = false;
        float animStartTime;
        float animTime;
        int animStartLoc;
        int animEndLoc;
        int animType;
        boolean animating = false;
        boolean attackAnim = false;
        PImage singleMove;
        PImage jumpImage;
        PImage blockImage;
        PImage punchImage;
        PImage jumpKickImage;

        public Player(PImage pImage, int n, int n2) {
            this.singleMove = sketch_10Seconds.this.loadImage("singleMove.png");
            this.jumpImage = sketch_10Seconds.this.loadImage("jumpOver.png");
            this.blockImage = sketch_10Seconds.this.loadImage("block.png");
            this.punchImage = sketch_10Seconds.this.loadImage("punchLeft.png");
            this.jumpKickImage = sketch_10Seconds.this.loadImage("jumpKick.png");
            this.curLoc = n;
            this.playerRedTint = n2;
            this.isAlive = true;
            this.playerImage = pImage;
        }

        public void prepSingleMove() {
            this.holdingSingle = true;
        }

        public void execSingleMove(Player player) {
            if (this.holdingSingle && !this.animating && !player.attackAnim) {
                int n = 1;
                if (player.curLoc > this.curLoc) {
                    n = -1;
                }
                int n2 = this.curLoc;
                if (sketch_10Seconds.abs((int)(player.curLoc - this.curLoc)) == 1) {
                    if (player.holdingDouble) {
                        this.curLoc += n;
                        player.animBlock(player.curLoc, player.curLoc);
                        player.holdingDouble = false;
                        sketch_10Seconds.this.blockSound.play(0);
                    } else {
                        player.curLoc -= 2 * n;
                        this.curLoc -= n;
                    }
                    this.animPunch(n2, this.curLoc);
                    sketch_10Seconds.this.punchSound.play(0);
                } else {
                    this.curLoc -= n;
                    this.animSingleMove(n2, this.curLoc);
                    sketch_10Seconds.this.singleMoveSound.play(0);
                }
            }
            this.holdingSingle = false;
        }

        public void prepDoubleMove() {
            this.holdingDouble = true;
        }

        public void execDoubleMove(Player player) {
            if (this.holdingDouble && !this.animating && !player.attackAnim) {
                int n = 1;
                if (player.curLoc > this.curLoc) {
                    n = -1;
                }
                int n2 = this.curLoc;
                if (sketch_10Seconds.abs((int)(player.curLoc - this.curLoc)) == 1) {
                    if (player.holdingSingle) {
                        int n3 = player.curLoc;
                        this.curLoc += n * 2;
                        player.curLoc += n * 2;
                        player.animBlock(n3, player.curLoc);
                        player.holdingSingle = false;
                        sketch_10Seconds.this.blockSound.play(0);
                    } else {
                        this.curLoc -= n * 2;
                        player.curLoc -= n * 2;
                    }
                    this.animDoubleMove(n2, this.curLoc, true);
                    sketch_10Seconds.this.jumpFlipSound.play(0);
                } else if (sketch_10Seconds.abs((int)(player.curLoc - this.curLoc)) == 2) {
                    if (player.holdingSingle) {
                        this.curLoc -= n * 3;
                        player.animBlock(player.curLoc, player.curLoc);
                        player.holdingSingle = false;
                        sketch_10Seconds.this.blockSound.play(0);
                    } else {
                        this.curLoc -= n * 2;
                        player.curLoc -= n;
                    }
                    this.animJumpKick(n2, this.curLoc);
                    sketch_10Seconds.this.jumpKickSound.play(0);
                } else {
                    this.curLoc -= 2 * n;
                    this.animDoubleMove(n2, this.curLoc, false);
                    sketch_10Seconds.this.doubleMoveSound.play(0);
                }
            }
            this.holdingDouble = false;
        }

        public void draw(Player player) {
            this.checkIfAlive();
            if (this.isAlive) {
                if (this.playerImage != null) {
                    float f = 1.0f;
                    sketch_10Seconds.this.pushMatrix();
                    if (this.curLoc < player.curLoc) {
                        f *= -1.0f;
                        sketch_10Seconds.this.scale(-1.0f, 1.0f);
                    }
                    if (this.animStartTime + this.animTime > (float)sketch_10Seconds.this.millis()) {
                        float f2 = (this.animStartTime + this.animTime - (float)sketch_10Seconds.this.millis()) / this.animTime;
                        float f3 = f2 / 4.0f;
                        float f4 = 1.0f - f3;
                        float f5 = (float)this.animEndLoc - f2 * (float)(this.animEndLoc - this.animStartLoc);
                        if (this.animType == 0) {
                            sketch_10Seconds.this.tint(this.playerRedTint, 0.0f, 255 - this.playerRedTint, f4 * 255.0f);
                            sketch_10Seconds.this.image(this.singleMove, f * f5 * 64.0f, 0.0f, f * 64.0f, 64.0f);
                        } else if (this.animType == 1) {
                            sketch_10Seconds.this.tint(this.playerRedTint, 0.0f, 255 - this.playerRedTint, f4 * 255.0f);
                            sketch_10Seconds.this.image(this.jumpImage, f * f5 * 64.0f, 0.0f, f * 64.0f, 64.0f);
                        } else if (this.animType == 2) {
                            sketch_10Seconds.this.tint(this.playerRedTint, 0.0f, 255 - this.playerRedTint, f4 * 255.0f);
                            sketch_10Seconds.this.image(this.blockImage, f * (float)this.curLoc * 64.0f, 0.0f, f * 64.0f, 64.0f);
                        } else if (this.animType == 3) {
                            sketch_10Seconds.this.tint(this.playerRedTint, 0.0f, 255 - this.playerRedTint, f4 * 255.0f);
                            sketch_10Seconds.this.image(this.punchImage, f * f5 * 64.0f, 0.0f, f * 64.0f, 64.0f);
                        } else if (this.animType == 4) {
                            sketch_10Seconds.this.tint(this.playerRedTint, 0.0f, 255 - this.playerRedTint, f4 * 255.0f);
                            sketch_10Seconds.this.image(this.jumpKickImage, f * f5 * 64.0f, 0.0f, f * 64.0f, 64.0f);
                        }
                    } else {
                        sketch_10Seconds.this.tint(this.playerRedTint, 0.0f, 255 - this.playerRedTint, 255.0f);
                        this.animating = false;
                        this.attackAnim = false;
                        sketch_10Seconds.this.image(this.playerImage, f * (float)this.curLoc * 64.0f, 0.0f, f * 64.0f, 64.0f);
                    }
                    sketch_10Seconds.this.popMatrix();
                } else {
                    sketch_10Seconds.this.fill(this.playerRedTint, 0.0f, 255 - this.playerRedTint);
                    sketch_10Seconds.this.drawSquare(this.curLoc);
                    this.animating = false;
                }
            }
        }

        public void animSingleMove(int n, int n2) {
            this.animStartLoc = n;
            this.animEndLoc = n2;
            this.animStartTime = sketch_10Seconds.this.millis();
            this.animTime = 70.0f / sketch_10Seconds.this.gameSpeed;
            this.animType = 0;
            this.animating = true;
        }

        public void animDoubleMove(int n, int n2, boolean bl) {
            this.animStartLoc = n;
            this.animEndLoc = n2;
            this.animStartTime = sketch_10Seconds.this.millis();
            this.animTime = 160.0f / sketch_10Seconds.this.gameSpeed;
            this.animType = 1;
            this.animating = true;
            if (bl) {
                this.attackAnim = true;
            }
        }

        public void animBlock(int n, int n2) {
            this.animStartTime = sketch_10Seconds.this.millis();
            this.animTime = 150.0f / sketch_10Seconds.this.gameSpeed;
            this.animType = 2;
            this.animating = true;
        }

        public void animPunch(int n, int n2) {
            this.animStartLoc = n;
            this.animEndLoc = n2;
            this.animStartTime = sketch_10Seconds.this.millis();
            this.animTime = 250.0f / sketch_10Seconds.this.gameSpeed;
            this.animType = 3;
            this.animating = true;
            this.attackAnim = true;
        }

        public void animJumpKick(int n, int n2) {
            this.animStartLoc = n;
            this.animEndLoc = n2;
            this.animStartTime = sketch_10Seconds.this.millis();
            this.animTime = 250.0f / sketch_10Seconds.this.gameSpeed;
            this.animType = 4;
            this.animating = true;
            this.attackAnim = true;
        }

        public void checkIfAlive() {
            this.isAlive = this.curLoc >= sketch_10Seconds.this.boardLeft && this.curLoc <= sketch_10Seconds.this.boardRight;
        }
    }
}

